use master

-- Kill all DB connections
DECLARE @dbname sysname
DECLARE @spid int

SET @dbname = '$(varDataBaseName)'

SELECT @spid = min(spid) from master.dbo.sysprocesses where dbid = db_id(@dbname)
WHILE @spid IS NOT NULL
BEGIN
EXECUTE ('KILL ' + @spid)
SELECT @spid = min(spid) from master.dbo.sysprocesses where dbid = db_id(@dbname) AND spid > @spid
END

DROP DATABASE [$(varDataBaseName)]

GO

-- Kill ended

RESTORE DATABASE [$(varDataBaseName)] 
	FROM  DISK = N'$(varRestoreFromPath)' WITH  FILE = 1,
	MOVE N'$(varOldDataBaseName)_Data' TO N'$(varMoveDFToPath)\$(varDataBaseName)_Data.mdf',  
	MOVE N'BMS_ftrow_evsCatalog' TO N'$(varMoveDFToPath)\EVS_2.EVS_evsCatalog', 
	MOVE N'$(varOldDataBaseName)_Log' TO N'$(varMoveDFToPath)\$(varDataBaseName)_log.ldf',  
	NOUNLOAD,  REPLACE,  STATS = 10

ALTER DATABASE [$(varDataBaseName)]
MODIFY FILE
(NAME = N'$(varOldDataBaseName)_Data', NEWNAME=N'$(varDataBaseName)_Data')

ALTER DATABASE [$(varDataBaseName)]
MODIFY FILE
(NAME = N'$(varOldDataBaseName)_Log', NEWNAME=N'$(varDataBaseName)_Log')

ALTER DATABASE [$(varDataBaseName)]
MODIFY FILE
(NAME = N'BMS_ftrow_evsCatalog', NEWNAME=N'BMS_CURRENT_ftrow_evsCatalog')

GO